import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { catchError, Observable } from 'rxjs';
import { RiskControl } from '../model/risk-control';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';

@Injectable({
  providedIn: 'root'
})
export class RiskManagementControlService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService)
  constructor() { }

  getRiskManagementControlList(riskId: string): Observable<RiskControl[] | CommonError> {
    const url = `RiskControl/${riskId}`;
    return this.httpClient
      .get<RiskControl[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError))
  }

  addRiskManagementControl(control: RiskControl): Observable<RiskControl> {
    const url = 'RiskControl';
    return this.httpClient
      .post<RiskControl>(url, control);

  }

  updateRiskManagementControl(control: RiskControl): Observable<RiskControl> {
    const url = `RiskControl/${control.id}`;
    return this.httpClient
      .put<RiskControl>(url, control);
  }
}
