import { Component, inject, OnInit } from '@angular/core';
import { MatTabsModule } from '@angular/material/tabs';
import { ActivatedRoute, NavigationEnd, Router, RouterOutlet } from '@angular/router';
import { TranslateModule } from '@ngx-translate/core';
import { HasClaimDirective } from '@shared/has-claim.directive';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { BaseComponent } from '../../base.component';

@Component({
  selector: 'app-risk-details',
  imports: [
    MatTabsModule,
    RouterOutlet,
    PageHelpTextComponent,
    HasClaimDirective,
    TranslateModule
  ],
  templateUrl: './risk-details.component.html',
  styleUrl: './risk-details.component.scss'
})
export class RiskDetailsComponent extends BaseComponent implements OnInit {
  router = inject(Router);
  route = inject(ActivatedRoute);
  selectedTabIndex = 0;

  riskId: string | null = null;

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.riskId = params.get('id');
    });

    this.setTabIndexFromUrl(this.router.url);

    this.sub$.sink = this.router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {
        this.setTabIndexFromUrl(event.urlAfterRedirects);
      }
    });
  }

  setTabIndexFromUrl(url: string) {
    if (url.includes('attachment')) {
      this.selectedTabIndex = 3;
    } else if (url.includes('review')) {
      this.selectedTabIndex = 2;
    } else if (url.includes('control')) {
      this.selectedTabIndex = 1;
    } else if (url.includes('/risk/details')) {
      this.selectedTabIndex = 0;
    }
  }

  onTabChange(index: number) {
    switch (index) {
      case 0:
        this.router.navigate([`/risk/details/${this.riskId}`], { queryParams: { isDetailsMode: true } });
        break;
      case 1:
        this.router.navigate([`/risk/details/${this.riskId}/control`]);
        break;
      case 2:
        this.router.navigate([`/risk/details/${this.riskId}/review`]);
        break;
      case 3:
        this.router.navigate([`/risk/details/${this.riskId}/attachment`]);
        break;
    }
  }
}
