
import { inject, Injectable } from '@angular/core';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { Observable, catchError } from 'rxjs';
import { Risk } from '../model/risk';
import { RiskResource } from '../model/risk-resource';
import { HttpClient, HttpResponse, HttpParams } from '@angular/common/http';

@Injectable({
  providedIn: 'root'
})
export class RiskLogService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService)
  constructor() { }

  getRisks(riskResource: RiskResource): Observable<HttpResponse<Risk[]>> {
    const url = 'RiskLog';
    const params = new HttpParams()
      .set('orderBy', riskResource.orderBy)
      .set('pageSize', riskResource.pageSize.toString())
      .set('skip', riskResource.skip.toString())
      .set('totalCount', riskResource.totalCount.toString())
      .set('title', riskResource.title || '')
      .set('assignedToId', riskResource.assignedToId || '')
      .set('riskCategoryId', riskResource.riskCategoryId || '')
      .set('createdFromDate', riskResource.createdFromDate ? riskResource.createdFromDate.toISOString() : '')
      .set('createdToDate', riskResource.createdToDate ? riskResource.createdToDate.toISOString() : '')
      .set('status', riskResource.status?.toString() || '')
      .set('riskScore', riskResource.riskScore ? riskResource.riskScore?.toString() : '')
      .set('riskLevel', riskResource.riskLevel || '')
      .set('logStatus', riskResource.logStatus?.toString() || '');
    return this.httpClient
      .get<Risk[]>(url, {
        params: params,
        observe: 'response'
      });

  }
}
