import { Component, inject, Input, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { RiskReview as RiskReview } from '../../model/risk-review';
import { MatTableModule } from '@angular/material/table';
import { MatDialog } from '@angular/material/dialog';
import { ManageRiskManagementReviewComponent } from '../manage-risk-review/manage-risk-review.component';
import { BaseComponent } from '../../../base.component';
import { RiskManagementReviewService } from '../risk-management-review.service';
import { TranslateModule } from '@ngx-translate/core';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { ActivatedRoute } from '@angular/router';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';
import { NgClass } from '@angular/common';
import { MatButtonModule } from '@angular/material/button';

@Component({
  selector: 'app-risk-management-review-list',
  imports: [
    MatTableModule,
    TranslateModule,
    UTCToLocalTime,
    MatIconModule,
    MatCardModule,
    NgClass,
    MatButtonModule
  ],
  templateUrl: './risk-management-review-list.component.html',
  styleUrl: './risk-management-review-list.component.scss'
})
export class RiskManagementReviewListComponent extends BaseComponent implements OnInit, OnChanges {
  @Input() riskManagementReviewReaponse: RiskReview = {} as RiskReview;

  dialog = inject(MatDialog);
  riskReviewService = inject(RiskManagementReviewService);
  riskReviewList: RiskReview[] = [];
  displayedColumns: string[] = ['action', 'reviewerName', 'likelihood', 'impact', 'riskScore', 'riskLevel', 'reviewDate'];
  route = inject(ActivatedRoute);

  ngOnInit(): void {
    this.route.parent?.params.subscribe(params => {
      const riskId = params['id'];
      if (riskId) {
        this.getAllReviews(riskId);
      }
    });
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes['riskManagementReviewReaponse'] && this.riskManagementReviewReaponse) {
      this.riskReviewList = [...this.riskReviewList, this.riskManagementReviewReaponse];
    }
  }

  getAllReviews(riskId: string) {
    this.sub$.sink = this.riskReviewService.getRiskReviewById(riskId).subscribe({
      next: (reviews) => {
        const riskManagementReviews = reviews as RiskReview[];
        if (riskManagementReviews) {
          this.riskReviewList = riskManagementReviews;
        }
      }
    })
  }

  viewRiskManagementControl(riskReview: RiskReview) {
    const dialogRef = this.dialog.open(ManageRiskManagementReviewComponent, {
      maxWidth: '60vw',
      width: '100%',
      data: { riskReview, isViewOnly: true },
    });

    this.sub$.sink = dialogRef.afterClosed().subscribe((result: RiskReview) => {
      if (result) {
        const index = this.riskReviewList.findIndex(a => a.id === result.id);
        if (index !== -1) {
          this.riskReviewList[index] = result;
          this.riskReviewList = [...this.riskReviewList];
        }
      }
    });
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.riskReviewList.indexOf(row);
  }
}
