import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { RiskReview } from '../model/risk-review';
import { CommonError } from '@core/error-handler/common-error';
import { catchError, Observable } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class RiskManagementReviewService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService)
  constructor() { }

  getRiskReviewById(riskId: string): Observable<RiskReview[] | CommonError> {
    const url = `RiskReview/${riskId}`;
    return this.httpClient
      .get<RiskReview[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError))
  }

  addRiskManagementReview(control: RiskReview): Observable<RiskReview> {
    const url = 'RiskReview';
    return this.httpClient
      .post<RiskReview>(url, control);
  }

  updateRiskManagementReview(control: RiskReview): Observable<RiskReview> {
    const url = `RiskReview/${control.id}`;
    return this.httpClient
      .put<RiskReview>(url, control);
  }
}