import { Routes } from '@angular/router';
import { RiskDetailsComponent } from './risk-details/risk-details.component';
import { AuthGuard } from '@core/security/auth.guard';
import { RiskResolver } from './risk/risk.resolver';

export const RISK_ROUTES: Routes = [
  {
    path: 'manage',
    canMatch: [AuthGuard],
    data: { claimType: 'ADD_RISK_MANAGEMENT' },
    loadComponent: () =>
      import(
        './risk/manage-risk/manage-risk.component'
      ).then((c) => c.ManageRiskComponent),
  },
  {
    path: 'manage/:id',
    canMatch: [AuthGuard],
    data: { claimType: 'EDIT_RISK_MANAGEMENT' },
    loadComponent: () =>
      import(
        './risk/manage-risk/manage-risk.component'
      ).then((c) => c.ManageRiskComponent),
    resolve: {
      riskDetails: RiskResolver,
    },
  },
  {
    path: 'list',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_RISK_MANAGEMENT' },
    loadComponent: () =>
      import('./risk/risk-list/risk-list.component').then(
        (c) => c.RiskListComponent
      ),
  },
  {
    path: 'categories',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_RISK_CATEGORY' },
    loadComponent: () =>
      import('./risk-category/risk-management-category-list/risk-management-category-list.component').then(
        (c) => c.RiskManagementCategoryListComponent
      ),
  },
  {
    path: 'logs',
    canMatch: [AuthGuard],
    data: { claimType: 'MANAGE_RISK_LOGS' },
    loadComponent: () =>
      import('./risk-log-list/risk-log-list.component').then(
        (c) => c.RiskLogListComponent
      ),
  },
  {
    path: 'my-risk-list',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_RISK_LIST' },
    loadComponent: () =>
      import('./risk/my-risk-list/my-risk-list').then(
        (c) => c.MyRiskList
      ),
  },
  {
    path: 'details/:id',
    component: RiskDetailsComponent,
    children: [
      {
        path: '',
        canMatch: [AuthGuard],
        data: { claimType: 'DETAILS_RISK_MANAGEMENT' },
        loadComponent: () =>
          import(
            './risk/manage-risk/manage-risk.component'
          ).then((c) => c.ManageRiskComponent),
        resolve: {
          riskDetails: RiskResolver,
        },
      },
      {
        path: 'control',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_RISK_CONTROL', 'ADD_RISK_CONTROL'] },
        loadComponent: () =>
          import(
            './risk-control/manage-risk-management-control/manage-risk-management-control.component'
          ).then((c) => c.ManageRiskManagementControlComponent),
      },
      {
        path: 'review',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_RISK_REVIEW', 'ADD_RISK_REVIEW'] },
        loadComponent: () =>
          import(
            './risk-review/manage-risk-review/manage-risk-review.component'
          ).then((c) => c.ManageRiskManagementReviewComponent),
      },
      {
        path: 'attachment',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_RISK_ATTACHMENT', 'ADD_RISK_ATTACHMENT'] },
        loadComponent: () =>
          import('./risk-attachment/manage-risk-attachment/manage-risk-attachment.component').then(
            (c) => c.ManageRiskAttachmentComponent
          ),
      },
    ]
  },
];
