import { inject } from '@angular/core';
import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { RiskService } from './risk.service';
import { Risk } from '../model/risk';
import { Observable } from 'rxjs';

export const RiskResolver: ResolveFn<Risk | undefined> = (route: ActivatedRouteSnapshot, state) => {
  const riskService = inject(RiskService);
  const id = route.params['id'];

  if (id !== null) {
    return riskService.getRiskById(id) as Observable<Risk>;
  } return;
};
