import {
  Component,
  Input,
  OnChanges,
  SimpleChanges
} from '@angular/core';
import * as mammoth from 'mammoth';

@Component({
  selector: 'app-doc-preview',
  templateUrl: './doc-preview.component.html',
  styleUrls: ['./doc-preview.component.scss'],
  standalone: true,
  imports: [ ]
})
export class DocPreviewComponent implements OnChanges {
  @Input() documentBlob: Blob | null = null;
  docData: any = null;

  ngOnChanges(changes: SimpleChanges) {
    if (changes['documentBlob'] && this.documentBlob) {
      this.processBlob(this.documentBlob);
    }
  }


  processBlob(blob: Blob) {
    try {
      const reader = new FileReader();
      reader.onload = async (event) => {
        if (event?.target?.result) {
          const data = await mammoth.convertToHtml({ arrayBuffer: event?.target?.result as ArrayBuffer });
          this.docData = data.value;
        }
      };
      reader.readAsArrayBuffer(blob);
    }
    catch (error) {
      console.log(error);
    }
    finally { }
  }
}
