import { Pipe, PipeTransform } from '@angular/core';
import { SupplierAuditType } from '../model/supplier-audit-type.enum';

@Pipe({
  name: 'SupplierAuditType'
})
export class SupplierAuditTypePipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case SupplierAuditType.Initial:
        return 'INITIAL';
      case SupplierAuditType.Scheduled:
        return 'SCHEDULED';
      case SupplierAuditType.Unscheduled:
        return 'UNSCHEDULED';
      default:
        return '';
    }
  }
}
