import { Pipe, PipeTransform } from '@angular/core';
import { SUPPLIER_CERTIFICATION_STATUS } from '../model/supplier-certification-status.enum';

@Pipe({
  name: 'SupplierCertificationStatus'
})
export class SupplierCertificationStatusPipe implements PipeTransform {

  transform(value: string): string {
    switch (value) {
      case SUPPLIER_CERTIFICATION_STATUS.Active:
        return 'Active';
      case SUPPLIER_CERTIFICATION_STATUS.Expired:
        return 'Expired';
      case SUPPLIER_CERTIFICATION_STATUS.Revoked:
        return 'Revoked';
      default:
        return '';
    }
  }
}
