import { Pipe, PipeTransform } from '@angular/core';
import { SUPPLIER_QUALIFICATION_RESULT } from '../model/supplier-qualification.enum';

@Pipe({
  name: 'SupplierQualificationResult'
})
export class SupplierQualificationResultPipe implements PipeTransform {

  transform(value: string): string {
    switch (value) {
      case SUPPLIER_QUALIFICATION_RESULT.QUALIFIED:
        return 'Qualified';
      case SUPPLIER_QUALIFICATION_RESULT.NOT_QUALIFIED:
        return 'Not Qualified';
      case SUPPLIER_QUALIFICATION_RESULT.PENDING:
        return 'Pending';
      default:
        return '';
    }
  }

}
