import { Pipe, PipeTransform } from '@angular/core';
import { SupplierStatus } from '../model/supplier-status';

@Pipe({
  name: 'SupplierStatus'
})
export class SupplierStatusPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case SupplierStatus.Active:
        return 'ACTIVE';
      case SupplierStatus.Inactive:
        return 'INACTIVE';
      case SupplierStatus.Pending:
        return 'PENDING';
      case SupplierStatus.Suspended:
        return 'SUSPENDED';
      case SupplierStatus.Terminated:
        return 'TERMINATED';
      case SupplierStatus.Blacklisted:
        return 'BLACKLISTED';
      default:
        return '';
    }
  }
}
