import { HttpClient, HttpParams, HttpResponse } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { catchError, tap } from 'rxjs/operators';
import { SupplierAudit } from '../model/supplier-audit';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({
  providedIn: 'root',
})
export class SupplierAuditService {
  constructor(
    private httpClient: HttpClient,
    private commonHttpErrorService: CommonHttpErrorService
  ) { }

  getSupplierAudit(id: string): Observable<SupplierAudit[]> {
    const url = `SupplierAudit/${id}`;
    return this.httpClient
      .get<SupplierAudit[]>(url);

  }

  addSupplierAudit(supplierAudit: SupplierAudit): Observable<SupplierAudit> {
    const url = `SupplierAudit`;
    return this.httpClient
      .post<SupplierAudit>(url, supplierAudit);

  }
}
