import { inject, Injectable } from '@angular/core';
import { SupplierCertification } from '../model/supplier-certification';
import { catchError, Observable } from 'rxjs';
import { CommonError } from '@core/error-handler/common-error';
import { HttpClient } from '@angular/common/http';
import { CourseSessionMedia } from '@core/domain-classes/course-session-media';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';

@Injectable({
  providedIn: 'root'
})
export class SupplierCertificationService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);

  constructor() { }

  getSupplierCertification(supplierId: string): Observable<SupplierCertification[] | CommonError> {
    const url = `SupplierCertification/${supplierId}`;
    return this.httpClient
      .get<SupplierCertification[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  saveIndividualDocument(document: SupplierCertification): Observable<SupplierCertification> {
    const url = 'SupplierCertification';
    const formData = new FormData();
    formData.append('supplierId', document.supplierId ?? '');
    formData.append('certificationNumber', document.certificationNumber ?? '');
    formData.append('certificationName', document.certificationName ?? '');
    formData.append('issuedBy', document.issuedBy ?? '');
    formData.append('issuedDate', document.issuedDate.toISOString());
    formData.append('status', document.status ?? '');
    formData.append('fileName', document.fileName ?? '');
    if (document.filePath) {
      formData.append('filePath', document.filePath);
    }
    if (document.id) {
      formData.append('id', document.id);
    }
    if (document.file) {
      formData.append('file', document.file as Blob);
    }
    if (document.expiryDate) {
      formData.append('expiryDate', document.expiryDate.toISOString());
    }
    return this.httpClient
      .post<SupplierCertification>(url, formData);

  }

  deleteSupplierCertification(id: string): Observable<void | CommonError> {
    const url = `SupplierCertification/${id}`;
    return this.httpClient
      .delete<void>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
