import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { catchError } from 'rxjs/operators';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { SupplierContact } from '../model/supplier-contact';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({
  providedIn: 'root'
})
export class SupplierContactService {
  constructor(
    private httpClient: HttpClient,
    private commonHttpErrorService: CommonHttpErrorService
  ) { }

  getSupplierContact(id: string): Observable<SupplierContact[]> {
    const url = `SupplierContact/${id}`;
    return this.httpClient
      .get<SupplierContact[]>(url);

  }

  addSupplierContact(supplierContact: SupplierContact): Observable<SupplierContact> {
    const url = `SupplierContact`;
    return this.httpClient
      .post<SupplierContact>(url, supplierContact);

  }

  deleteSupplierContact(id: string): Observable<void | CommonError> {
    const url = `SupplierContact/${id}`;
    return this.httpClient
      .delete<void>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
