import { Component, inject, OnInit } from '@angular/core';
import { MatTabsModule } from '@angular/material/tabs';
import { ActivatedRoute, NavigationEnd, Router, RouterOutlet } from '@angular/router';
import { TranslateModule } from '@ngx-translate/core';
import { HasClaimDirective } from '@shared/has-claim.directive';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { BaseComponent } from '../../base.component';

@Component({
  selector: 'app-supplier-details',
  imports: [
    MatTabsModule,
    PageHelpTextComponent,
    RouterOutlet,
    TranslateModule,
    HasClaimDirective
  ],
  templateUrl: './supplier-details.component.html',
  styleUrl: './supplier-details.component.scss',
})
export class SupplierDetailsComponent extends BaseComponent implements OnInit {
  router = inject(Router);
  route = inject(ActivatedRoute);
  selectedTabIndex = 0;
  userId: string | null = null;

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.userId = params.get('id');
    });

    this.setTabIndexFromUrl(this.router.url);

    this.sub$.sink = this.router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {
        this.setTabIndexFromUrl(event.urlAfterRedirects);
      }
    });
  }

  setTabIndexFromUrl(url: string) {
    if (url.includes('certification')) {
      this.selectedTabIndex = 5;
    } else if (url.includes('qualification')) {
      this.selectedTabIndex = 4;
    } else if (url.includes('performance')) {
      this.selectedTabIndex = 3;
    } else if (url.includes('contact')) {
      this.selectedTabIndex = 2;
    } else if (url.includes('audit')) {
      this.selectedTabIndex = 1;
    } else if (url.includes('/supplier/details')) {
      this.selectedTabIndex = 0;
    }
  }

  onTabChange(index: number) {
    switch (index) {
      case 0:
        this.router.navigate(['/supplier/details', this.userId], { queryParams: { isDetailsMode: true } });
        break;
      case 1:
        this.router.navigate(['/supplier/details', this.userId, 'audit']);
        break;
      case 2:
        this.router.navigate(['/supplier/details', this.userId, 'contact']);
        break;
      case 3:
        this.router.navigate(['/supplier/details', this.userId, 'performance']);
        break;
      case 4:
        this.router.navigate(['/supplier/details', this.userId, 'qualification']);
        break;
      case 5:
        this.router.navigate(['/supplier/details', this.userId, 'certification']);
        break;
    }
  }
}

