import { Component, inject, Input, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { MatTableModule } from '@angular/material/table';
import { SupplierPerformance } from '../../model/supplier-performance';
import { MatDialog } from '@angular/material/dialog';
import { ManageSupplierPerformanceComponent } from '../manage-supplier-performance/manage-supplier-performance.component';
import { BaseComponent } from '../../../base.component';
import { SupplierPerformanceService } from '../supplier-performance.service';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { TranslateModule } from '@ngx-translate/core';
import { ActivatedRoute } from '@angular/router';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';
import { NgClass } from '@angular/common';
import { MatButtonModule } from '@angular/material/button';

@Component({
  selector: 'app-supplier-performance-list',
  imports: [
    MatTableModule,
    UTCToLocalTime,
    TranslateModule,
    MatIconModule,
    MatCardModule,
    NgClass,
    MatButtonModule
  ],
  templateUrl: './supplier-performance-list.component.html',
  styleUrl: './supplier-performance-list.component.scss'
})
export class SupplierPerformanceListComponent extends BaseComponent implements OnInit, OnChanges {
  @Input() supplierPerformanceResponse: SupplierPerformance | null = null;

  displayedColumns: string[] = ['action', 'criteria', 'score', 'evaluatedBy', 'evaluationDate'];
  supplierPerformanceList: SupplierPerformance[] = [];
  dialog = inject(MatDialog);
  supplierPerformanceService = inject(SupplierPerformanceService);
  route = inject(ActivatedRoute);


  ngOnInit(): void {
    this.route.parent?.paramMap.subscribe((params) => {
      const supplierId = params.get('id');
      if (supplierId) {
        this.getAllSupplierPerformances(supplierId);
      }
    });
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes['supplierPerformanceResponse'] && this.supplierPerformanceResponse) {
      this.supplierPerformanceList = [...this.supplierPerformanceList, this.supplierPerformanceResponse];
    }
  }

  getAllSupplierPerformances(supplierId: string) {
    this.sub$.sink = this.supplierPerformanceService.getSupplierPerformance(supplierId).subscribe({
      next: (performances: SupplierPerformance[]) => {
        if (performances && performances.length > 0) {
          this.supplierPerformanceList = performances;
        } else {
          this.supplierPerformanceList = [];
        }
      }
    });
  }

  viewSupplierPerformance(supplierPerformance: SupplierPerformance) {
    this.dialog.open(ManageSupplierPerformanceComponent, {
      maxWidth: '60Vw',
      width: '100%',
      data: { supplierPerformance, isViewOnly: true },
    });
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.supplierPerformanceList.indexOf(row);
  }
}
