import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { catchError } from 'rxjs/operators';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { SupplierPerformance } from '../model/supplier-performance';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({
  providedIn: 'root'
})
export class SupplierPerformanceService {
  constructor(
    private httpClient: HttpClient,
    private commonHttpErrorService: CommonHttpErrorService
  ) { }

  getSupplierPerformance(id: string): Observable<SupplierPerformance[]> {
    const url = `SupplierPerformance/${id}`;
    return this.httpClient
      .get<SupplierPerformance[]>(url);

  }

  addSupplierPerformance(supplierPerformance: SupplierPerformance): Observable<SupplierPerformance> {
    const url = `SupplierPerformance`;
    return this.httpClient
      .post<SupplierPerformance>(url, supplierPerformance);

  }

  deleteSupplierPerformance(id: string): Observable<void | CommonError> {
    const url = `SupplierPerformance/${id}`;
    return this.httpClient
      .delete<void>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
