import { Component, inject, Input, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { MatTableModule } from '@angular/material/table';
import { BaseComponent } from '../../../base.component';
import { SupplierQualification } from '../../model/supplier-qualification';
import { MatDialog } from '@angular/material/dialog';
import { ManageSupplierQualificationComponent } from '../manage-supplier-qualification/manage-supplier-qualification.component';
import { SupplierQualificationService } from '../supplier-qualification.service';
import { TranslateModule } from '@ngx-translate/core';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { ActivatedRoute } from '@angular/router';
import { NgClass } from '@angular/common';
import { SupplierQualificationResultPipe } from '../../pipes/supplier-qualification-result.pipe';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';
import { MatButtonModule } from '@angular/material/button';

@Component({
  selector: 'app-supplier-qualification-list',
  imports: [
    MatTableModule,
    TranslateModule,
    UTCToLocalTime,
    SupplierQualificationResultPipe,
    NgClass,
    MatIconModule,
    MatCardModule,
    MatButtonModule
  ],
  templateUrl: './supplier-qualification-list.component.html',
  styleUrl: './supplier-qualification-list.component.scss'
})
export class SupplierQualificationListComponent extends BaseComponent implements OnInit, OnChanges {
  @Input() supplierQualification: SupplierQualification = {} as SupplierQualification;

  displayedColumns: string[] = ['action', 'qualificationName', 'qualificationDate', 'criteria', 'result'];
  supplierQualificationList: SupplierQualification[] = [];
  dialog = inject(MatDialog);
  supplierQualificationService = inject(SupplierQualificationService);
  route = inject(ActivatedRoute);

  ngOnInit(): void {
    this.route.parent?.paramMap.subscribe((params) => {
      const supplierId = params.get('id');
      if (supplierId) {
        this.getAllSupplierQualifications(supplierId);
      }
    });
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes['supplierQualification'] && this.supplierQualification) {
      this.supplierQualificationList = [...this.supplierQualificationList, this.supplierQualification];
    }
  }

  getAllSupplierQualifications(supplierId: string) {
    this.sub$.sink = this.supplierQualificationService.getSupplierQualification(supplierId)
      .subscribe((qualifications: SupplierQualification[]) => {
        this.supplierQualificationList = qualifications;
      });
  }

  viewSupplierQualification(qualification: SupplierQualification): void {
    this.dialog.open(ManageSupplierQualificationComponent, {
      maxWidth: '60vw',
      width: '100%',
      data: { supplierQualification: qualification, isViewOnly: true },
    });
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.supplierQualificationList.indexOf(row);
  }
}
