import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { SupplierQualification } from '../model/supplier-qualification';
import { CommonError } from '@core/error-handler/common-error';
import { Observable, catchError } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class SupplierQualificationService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getSupplierQualification(id: string): Observable<SupplierQualification[]> {
    const url = `SupplierQualification/${id}`;
    return this.httpClient
      .get<SupplierQualification[]>(url);

  }

  addSupplierQualification(supplierQualification: SupplierQualification): Observable<SupplierQualification> {
    const url = `SupplierQualification`;
    return this.httpClient
      .post<SupplierQualification>(url, supplierQualification);

  }
}
