import { Routes } from '@angular/router';
import { SupplierDetailsComponent } from './supplier-details/supplier-details.component';
import { AuthGuard } from '@core/security/auth.guard';
import { SupplierResolver } from './supplier.resolver';

export const SUPPLIER_ROUTES: Routes = [
  {
    path: 'list',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_SUPPLIER' },
    loadComponent: () =>
      import('./supplier-list/supplier-list.component').then(
        (c) => c.SupplierListComponent
      ),
  },
  {
    path: 'manage',
    canMatch: [AuthGuard],
    data: { claimType: ['ADD_SUPPLIER', 'EDIT_SUPPLIER'] },
    loadComponent: () =>
      import('./manage-supplier/manage-supplier.component').then(
        (m) => m.ManageSupplierComponent
      ),
  },
  {
    path: 'manage/:id',
    canMatch: [AuthGuard],
    data: { claimType: ['ADD_SUPPLIER', 'EDIT_SUPPLIER'] },
    loadComponent: () =>
      import('./manage-supplier/manage-supplier.component').then(
        (m) => m.ManageSupplierComponent
      ),
    resolve: {
      supplier: SupplierResolver,
    },
  },
  {
    path: 'details/:id',
    component: SupplierDetailsComponent,
    children: [
      {
        path: '',
        canMatch: [AuthGuard],
        data: { claimType: 'DETAILS_SUPPLIER' },
        loadComponent: () =>
          import(
            './manage-supplier/manage-supplier.component'
          ).then((c) => c.ManageSupplierComponent),
        resolve: {
          supplier: SupplierResolver,
        },
      },
      {
        path: 'audit',
        canMatch: [AuthGuard],
        data: { claimType: 'VIEW_SUPPLIER_AUDIT' },
        loadComponent: () =>
          import(
            './supplier-audit/manage-supplier-audit/manage-supplier-audit.component'
          ).then((c) => c.ManageSupplierAuditComponent),
      },
      {
        path: 'contact',
        canMatch: [AuthGuard],
        data: { claimType: 'VIEW_SUPPLIER_CONTACT' },
        loadComponent: () =>
          import(
            './supplier-contact/manage-supplier-contact/manage-supplier-contact.component'
          ).then((c) => c.ManageSupplierContactComponent),
      },
      {
        path: 'performance',
        canMatch: [AuthGuard],
        data: { claimType: 'VIEW_SUPPLIER_PERFORMANCE' },
        loadComponent: () =>
          import(
            './supplier-performance/manage-supplier-performance/manage-supplier-performance.component'
          ).then((c) => c.ManageSupplierPerformanceComponent),
      },
      {
        path: 'qualification',
        canMatch: [AuthGuard],
        data: { claimType: 'VIEW_SUPPLIER_QUALIFICATION' },
        loadComponent: () =>
          import(
            './supplier-qualification/manage-supplier-qualification/manage-supplier-qualification.component'
          ).then((c) => c.ManageSupplierQualificationComponent),
      },
      {
        path: 'certification',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_SUPPLIER_CERTIFICATION', 'CREATE_SUPPLIER_CERTIFICATION'] },
        loadComponent: () =>
          import(
            './supplier-certification/manage-supplier-certification/manage-supplier-certification.component'
          ).then((c) => c.ManageSupplierCertificationComponent),
      },
    ],
  }
];
