import { inject } from '@angular/core';
import { ResolveFn } from '@angular/router';
import { Supplier } from '../supplier/model/supplier';
import { Observable } from 'rxjs';
import { SupplierService } from './supplier.service';

export const SupplierResolver: ResolveFn<Supplier | undefined> = (
  route,
  ActivatedRouteSnapshot
) => {
  const supplierService = inject(SupplierService);
  const id = route.params['id'];
  if (id != null) {
    return supplierService.getSupplier(id) as Observable<Supplier>;
  }
  return;
};
