import { Routes } from "@angular/router";
import { AuthGuard } from "@core/security/auth.guard";
import { courseResolver } from "./course/course.resolver";
import { employeeTrainingSessionResolver } from "./employee-training/employee-training-session.resolver";
import { sessionResolver } from "./course-session/course-session.resolver";
import { SessionTabViewComponent } from "./course-session/session-tab-view/session-tab-view.component";

export const COURSE_ROUTES: Routes = [
  {
    path: 'manage',
    canMatch: [AuthGuard],
    data: {
      claimType: [
        'ADD_COURSE',
        'EDIT_COURSE',
        'ASSIGN_COURSE',
      ],
    },
    loadComponent: () =>
      import(
        './course/manage-course/manage-course.component'
      ).then((c) => c.ManageCourseComponent),
    resolve: {
      courseDetail: courseResolver,
    },
  },
  {
    path: 'list',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_COURSE' },
    loadComponent: () =>
      import('./course/course-list/course-list.component').then(
        (c) => c.CourseListComponent
      ),
  },
  {
    path: 'manage/:id',
    canMatch: [AuthGuard],
    data: {
      claimType: [
        'ADD_COURSE',
        'EDIT_COURSE',
        'ASSIGN_COURSE',
      ],
    },
    loadComponent: () =>
      import(
        './course/manage-course/manage-course.component'
      ).then((c) => c.ManageCourseComponent),
    resolve: {
      courseDetail: courseResolver,
    },
  },
  {
    path: ':courseId/session',
    loadComponent: () =>
      import(
        './course-session/session-tab-view/session-tab-view.component'
      ).then((c) => c.SessionTabViewComponent),
    canMatch: [AuthGuard],
    children: [
      {
        path: '',
        canMatch: [AuthGuard],
        // data: { claimType: ['ADD_SESSION', 'EDIT_SESSION'] },
        loadComponent: () =>
          import(
            './course-session/manage-session/manage-session.component'
          ).then((c) => c.ManageSessionComponent),
      }
    ]
  },
  {
    path: ':courseId/session/:sessionId',
    component: SessionTabViewComponent,
    canMatch: [AuthGuard],
    children: [
      {
        path: '',
        canMatch: [AuthGuard],
        // data: { claimType: ['ADD_SESSION', 'EDIT_SESSION'] },
        loadComponent: () =>
          import(
            './course-session/manage-session/manage-session.component'
          ).then((c) => c.ManageSessionComponent),
        resolve: {
          courseSession: sessionResolver,
        },
      },
      {
        path: 'quiz',
        canMatch: [AuthGuard],
        // data: { claimType: ['VIEW_SESSION_QUIZ', 'EDIT_SESSION_QUIZ'] },
        loadComponent: () =>
          import('./course-session/session-quiz/session-quiz.component')
            .then(c => c.SessionQuizComponent),
      },
      {
        path: 'media',
        canMatch: [AuthGuard],
        // data: { claimType: ['VIEW_SESSION_MEDIA', 'EDIT_SESSION_MEDIA'] },
        loadComponent: () =>
          import('./course-session/session-media/session-media.component')
            .then(c => c.SessionMediaComponent),
      },
    ]
  },
  {
    path: 'assign',
    canMatch: [AuthGuard],
    data: { claimType: 'ASSIGN_COURSE' },
    loadComponent: () =>
      import(
        './course/assign-course/assign-course.component'
      ).then((c) => c.AssignCourseComponent),
  },
  {
    path: 'my-courses',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_COURSES' },
    loadComponent: () =>
      import('./my-courses-list/my-courses-list').then((c) => c.MyCoursesList),
  },
  {
    path: ':link',
    canMatch: [AuthGuard],
    loadComponent: () =>
      import(
        './employee-training/training/training.component'
      ).then((c) => c.TrainingComponent),
    resolve: {
      CourseSessionDetails: employeeTrainingSessionResolver,
    },
  }
];
