import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { Session } from '@core/domain-classes/session';
import { SessionService } from './course-session.service';
import { inject } from '@angular/core';
import { Observable } from 'rxjs';

export const sessionResolver: ResolveFn<Session | undefined> = (route: ActivatedRouteSnapshot) => {
  const sessionService = inject(SessionService);
  const id = route.params['sessionId'];
  if (id != null) {
    return sessionService.getSession(id) as Observable<Session>;
  } return;
};
