import { Component, inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, ReactiveFormsModule, Validators } from '@angular/forms';
import { ActivatedRoute, Data, Router, RouterLink } from '@angular/router';
import { TranslateModule } from '@ngx-translate/core';
import { SessionStore } from '../store/course-session.store';
import { toObservable } from '@angular/core/rxjs-interop';
import { CourseStore } from '../../course/store/course.store';
import { BaseComponent } from '../../../base.component';
import { TextEditorComponent } from '@shared/text-editor/text-editor.component';
import { MatButtonModule } from '@angular/material/button';
import { MatIconModule } from '@angular/material/icon';

@Component({
  selector: 'app-manage-session',
  imports: [
    TranslateModule,
    ReactiveFormsModule,
    RouterLink,
    TextEditorComponent,
    MatButtonModule,
    MatIconModule
  ],
  templateUrl: './manage-session.component.html',
  styleUrl: './manage-session.component.scss'
})
export class ManageSessionComponent extends BaseComponent implements OnInit {
  sessionForm!: FormGroup;
  fb = inject(FormBuilder);
  sessionStore = inject(SessionStore);
  isEdit = false;
  router = inject(Router);
  route = inject(ActivatedRoute);
  courseId = '';
  courseStore = inject(CourseStore);

  constructor() {
    super();
    this.subscribeIsAddorUpdate();
  }

  ngOnInit(): void {
    this.creatSessionForm();
    this.sub$.sink = this.route.parent?.params.subscribe(params => {
      this.courseId = params['courseId'];
      this.sessionForm.get('courseId')?.setValue(this.courseId);
    });
    this.sub$.sink = this.route.data.subscribe((response: Data) => {
      const session = response['courseSession'];
      if (session) {
        this.isEdit = true;
        this.sessionForm.patchValue(session);
        this.sessionStore.setCurrentSession(session);
      } else {
        this.isEdit = false;
      }
    });
  }

  creatSessionForm() {
    this.sessionForm = this.fb.group({
      id: [''],
      title: ['', Validators.required],
      courseId: [''],
      description: [''],
    })
  }

  onSubmit() {
    if (!this.sessionForm.valid) {
      this.sessionForm.markAllAsTouched();
      return;
    }
    if (!this.isEdit) {
      this.sessionStore.addCourseSession(this.sessionForm.getRawValue());
    } else if (this.isEdit) {
      this.sessionStore.updateCourseSession(this.sessionForm.getRawValue());
    }
  }

  subscribeIsAddorUpdate() {
    toObservable(this.sessionStore.isAddorUpdate).subscribe((flag) => {
      if (flag) {
        this.router.navigate([`course/${this.courseId}/session/${this.sessionStore.curruntSession.id()}/media`]);
      }
      this.sessionStore.resetIsAddFlag();
    });
  }
}
