import { Pipe, PipeTransform } from '@angular/core';
import { MediaTypeList } from '@core/domain-classes/session-media-type-enum';

@Pipe({
    name: 'mediaType',
    standalone: true,
})
export class MediaTypePipe implements PipeTransform {
    transform(value: number): string {
        return MediaTypeList.find((item) => item.id == value)?.type || 'Unknown';
    }
}
