import { Component } from '@angular/core';
import { inject, OnInit } from '@angular/core';
import { Router, ActivatedRoute, NavigationEnd, RouterOutlet } from '@angular/router';
import { TranslateModule } from '@ngx-translate/core';
import { MatTabsModule } from '@angular/material/tabs';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { NgStyle } from '@angular/common';
import { MatCardModule } from '@angular/material/card';
import { MatIconModule } from '@angular/material/icon';

import { ToastrService } from '@core/services/toastr-service';

@Component({
  selector: 'app-session-tab-view',
  imports: [
    RouterOutlet,
    TranslateModule,
    MatTabsModule,
    PageHelpTextComponent,
    NgStyle,
    MatCardModule,
    MatIconModule
  ],
  templateUrl: './session-tab-view.component.html',
  styleUrl: './session-tab-view.component.css'
})
export class SessionTabViewComponent implements OnInit {
  router = inject(Router);
  route = inject(ActivatedRoute);
  toaster = inject(ToastrService);
  selectedTabIndex = 0;
  courseId: string | null = null;
  sessionId: string | null = null;
  tabs = [
    { label: 'SESSION', icon: 'settings' },
    { label: 'SESSION_MEDIA', icon: 'video_library' },
    { label: 'SESSION_QUIZ', icon: 'help' }
  ];

  ngOnInit(): void {
    // Get parameters from route
    this.courseId = this.route.snapshot.paramMap.get('courseId');
    this.sessionId = this.route.snapshot.paramMap.get('sessionId');

    // Set initial tab based on current URL
    this.setTabIndexFromUrl(this.router.url);

    // Listen to navigation changes
    this.router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {
        this.setTabIndexFromUrl(event.urlAfterRedirects);
      }
    });
  }

  setTabIndexFromUrl(url: string): void {
    if (url.includes('/quiz')) {
      this.selectedTabIndex = 2;
    } else if (url.includes('/media')) {
      this.selectedTabIndex = 1;
    } else {
      this.selectedTabIndex = 0;
    }
  }

  onTabChange(index: number): void {
    if (this.courseId !== null && this.sessionId !== null) {
      const basePath = `/course/${this.courseId}/session/${this.sessionId}`;

      switch (index) {
        case 0:
          this.router.navigate([basePath]);
          break;
        case 1:
          this.router.navigate([basePath, 'media']);
          break;
        case 2:
          this.router.navigate([basePath, 'quiz']);
          break;
        default:
          console.warn('Unknown tab index:', index);
      }
    } else {
      this.toaster.error('Please fill the session information first.');
    }
  }
}
