import { Component, inject, Input, OnChanges, SimpleChanges } from '@angular/core';
import { MatTableModule } from '@angular/material/table';
import { TranslateModule } from '@ngx-translate/core';
import { RouterLink } from '@angular/router';
import { CommonDialogService } from '@core/common-dialog/common-dialog.service';
import { TranslationService } from '@core/services/translation.service';
import { Course } from '@core/domain-classes/course';
import { SessionStore } from '../../../course-session/store/course-session.store';
import { CourseStore } from '../../store/course.store';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { MatButtonModule } from '@angular/material/button';
import { MatCardModule } from '@angular/material/card';
import { MatIconModule } from '@angular/material/icon';

@Component({
  selector: 'app-course-session',
  imports: [
    TranslateModule,
    MatTableModule,
    RouterLink,
    PageHelpTextComponent,
    MatButtonModule,
    MatCardModule,
    MatIconModule
  ],
  templateUrl: './course-session.component.html',
  styleUrl: './course-session.component.scss'
})
export class CourseSessionComponent implements OnChanges {
  @Input() course!: Course;
  subActionColumnToDisplay = ['action', 'title'];
  commandDialogService = inject(CommonDialogService);
  translationService = inject(TranslationService);
  sessionStore = inject(SessionStore);
  courseStore = inject(CourseStore);

  ngOnChanges(changes: SimpleChanges): void {
    if (changes['course']) {
      this.getCourseSession();
    }
  }

  getCourseSession() {
    this.courseStore.setCurrentCouse(this.course);
    this.sessionStore.getCourseSession(this.course.id);
  }

  deleteSession(sessionId: string) {
    this.commandDialogService.deleteConfirmtionDialog(this.translationService.getValue("ARE_YOU_SURE_YOU_WANT_TO_DELETE_THIS_SESSION")).subscribe({
      next: (result: boolean) => {
        if (result) {
          this.sessionStore.deleteCourseSession(sessionId);
        }
      }
    });
  }
}
