import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { Course } from '@core/domain-classes/course';
import { CourseService } from './course.service';
import { inject } from '@angular/core';
import { Observable } from 'rxjs';

export const courseResolver: ResolveFn<Course | undefined> = (route: ActivatedRouteSnapshot) => {
  const courseService = inject(CourseService);
  const id = route.params['id']
  if (id != null) {
    return courseService.getCourse(id) as Observable<Course>;
  } return;
};
