import { inject } from '@angular/core';
import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { EmployeeTrainingService } from './employee-training.service';
import { Observable, tap } from 'rxjs';
import { EmployeeCourse } from '@core/domain-classes/employee-course-session';
import { CommonError } from '@core/error-handler/common-error';



export const employeeTrainingSessionResolver: ResolveFn<EmployeeCourse | CommonError | undefined> = (route: ActivatedRouteSnapshot) => {
  const employeeCourseService = inject(EmployeeTrainingService);
  const link = route.params['link'];
  if (link != null) {
    return employeeCourseService.getEmployeeCourseLink(link) as Observable<EmployeeCourse | CommonError>;
  }
  return;
};
