import { inject } from '@angular/core';
import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { SessionQuiz } from '@core/domain-classes/session-quiz';
import { EmployeeTrainingService } from '../employee-training.service';
import { Observable } from 'rxjs';

export const sessionQuizResolver: ResolveFn<SessionQuiz | undefined> = (route: ActivatedRouteSnapshot) => {
  const courseSessionId = route.params['courseSessionId'];
  const employeeCourseService = inject(EmployeeTrainingService);

  if (courseSessionId) {
    return employeeCourseService.getCourseSessionQuiz(courseSessionId) as Observable<SessionQuiz>;
  }
  return;
};