import { Routes } from "@angular/router";
import { AuthGuard } from "@core/security/auth.guard";
import { UserDetailResolverService } from "../../user/user-detail-resolver";

export const EMPLOYEE_ROUTES: Routes = [
  {
    path: 'list',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_EMPLOYEE' },
    loadComponent: () =>
      import(
        './employee-list/employee-list.component'
      ).then((c) => c.EmployeeListComponent),
  },
  {
    path: 'import',
    canMatch: [AuthGuard],
    data: { claimType: 'IMPORT_EMPLOYEE' },
    loadComponent: () =>
      import(
        './import-employee/import-employee.component'
      ).then((c) => c.ImportEmployeeComponent),
  },
  {
    path: 'details/:id',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_EMPLOYEE' },
    loadComponent: () =>
      import(
        './employee-details/employee-details.component'
      ).then((c) => c.EmployeeDetailsComponent),
    resolve: {
      employee: UserDetailResolverService
    }
  }
];
