import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { CourseAssignment } from '@core/domain-classes/course';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { catchError, Observable } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class MyCourses {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService)

  constructor() { }

  getAllPendingCourses(): Observable<CourseAssignment[] | CommonError> {
    const url = 'EmployeeCourse/my-courses/pending';
    return this.httpClient.get<CourseAssignment[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getAllInProgressCourses(): Observable<CourseAssignment[] | CommonError> {
    const url = 'EmployeeCourse/my-courses/in-progress';
    return this.httpClient.get<CourseAssignment[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getAllCompletedCourses(): Observable<CourseAssignment[] | CommonError> {
    const url = 'EmployeeCourse/my-courses/completed';
    return this.httpClient.get<CourseAssignment[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
