import { Pipe, PipeTransform } from '@angular/core';
import { EmployeeCourseStatus } from '../employee-training/employee-course-status.enum';

@Pipe({
  name: 'EmployeeCourseStatus'
})
export class EmployeeCourseStatusPipe implements PipeTransform {

  transform(value: EmployeeCourseStatus): string {
    switch (value) {
      case EmployeeCourseStatus.Pending:
        return 'PENDING';
      case EmployeeCourseStatus.InProgress:
        return 'IN_PROGRESS';
      case EmployeeCourseStatus.Completed:
        return 'COMPLETED';
      default:
        return '';
    }
  }
}
