import { Routes } from '@angular/router';
import { LayoutTrainingComponent } from '@core/layout-training/layout-training.component';
import { AuthGuard } from '@core/security/auth.guard';
import { employeeTrainingSessionResolver } from './employee-training/employee-training-session.resolver';
import { sessionQuizResolver } from './employee-training/session-quiz/session-quiz.resolver';

export const TRAINING_ROUTES: Routes = [
  {
    path: '',
    component: LayoutTrainingComponent,
    children: [
      {
        path: ':link/:id',
        canMatch: [AuthGuard],
        loadComponent: () =>
          import(
            './employee-training/training-course/training-course.component'
          ).then((c) => c.TrainingCourseComponent),
        resolve: {
          CourseSessionDetails: employeeTrainingSessionResolver,
        },
      },
      {
        path: ':link/session/:courseSessionId/quiz',
        canMatch: [AuthGuard],
        loadComponent: () =>
          import(
            './employee-training/session-quiz/session-quiz.component'
          ).then((c) => c.SessionQuizComponent),
        resolve: {
          sessionQuiz: sessionQuizResolver
        }
      },
    ],
  },
]
