import { Component, computed, inject, OnInit } from '@angular/core';
import { BaseComponent } from '../../base.component';
import { ActivatedRoute, Router } from '@angular/router';

import { ToastrService } from '@core/services/toastr-service';
import { User } from '@core/domain-classes/user';
import { UserService } from '../user.service';
import { UserPermissionPresentationComponent } from '../user-permission-presentation/user-permission-presentation.component';
import { CommonService } from '@core/services/common.service';
import { Module } from '@core/domain-classes/module';

@Component({
  selector: 'app-user-permission',
  templateUrl: './user-permission.component.html',
  styleUrls: ['./user-permission.component.scss'],
  standalone: true,
  imports: [
    UserPermissionPresentationComponent
  ]
})
export class UserPermissionComponent extends BaseComponent implements OnInit {
  modules: Module[] = [];
  user: User;

  constructor(
    private activeRoute: ActivatedRoute,
    private router: Router,
    private toastrService: ToastrService,
    private userService: UserService,
    private commonService: CommonService,
  ) {
    super();
  }



  ngOnInit(): void {
    this.loadPermissions();
    this.sub$.sink = this.activeRoute.data.subscribe(
      (data: any) => {
        this.user = data.user;
      });
  }

  loadPermissions(): void {
    this.sub$.sink = this.commonService
      .getAllPermissions()
      .subscribe((permissions) => {
        this.modules = permissions;
      });
  }

  manageUserClaimAction(user: User): void {
    const userClaims = user.userClaims?.length ? user.userClaims : [];
    this.sub$.sink = this.userService.updateUserClaim(userClaims, user.id ?? '').subscribe(() => {
      this.toastrService.success(this.translationService.getValue('USER_PERMISSION_UPDATED_SUCCESSFULLY'));
      this.router.navigate(['/users']);
    })
  }
}
